/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.entity.ai.brain.task.tuffgolem;

import com.faboslav.friendsandfoes.entity.TuffGolemEntity;
import com.faboslav.friendsandfoes.entity.ai.brain.TuffGolemBrain;
import com.faboslav.friendsandfoes.entity.pose.TuffGolemEntityPose;
import com.faboslav.friendsandfoes.init.FriendsAndFoesMemoryModuleTypes;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4141;

public final class TuffGolemSleepTask
extends class_4097<TuffGolemEntity> {
    private static final int MIN_TICKS_TO_SLEEP = 1200;
    private static final int MAX_TICKS_TO_SLEEP = 3600;

    public TuffGolemSleepTask() {
        super((Map)ImmutableMap.of(FriendsAndFoesMemoryModuleTypes.TUFF_GOLEM_SLEEP_COOLDOWN.get(), (Object)class_4141.field_18457), 1200, 3600);
    }

    protected boolean shouldRun(class_3218 world, TuffGolemEntity tuffGolem) {
        return tuffGolem.isAtHome() && tuffGolem.getKeyframeAnimationTicks() == 0 && tuffGolem.method_18868().method_18904(FriendsAndFoesMemoryModuleTypes.TUFF_GOLEM_SLEEP_COOLDOWN.get()).isEmpty();
    }

    protected void run(class_3218 world, TuffGolemEntity tuffGolem, long time) {
        tuffGolem.method_33574(tuffGolem.getHomePos());
        tuffGolem.setSpawnYaw(tuffGolem.getHomeYaw());
        if (tuffGolem.method_41328(TuffGolemEntityPose.STANDING.get())) {
            tuffGolem.startSleeping();
        } else if (tuffGolem.method_41328(TuffGolemEntityPose.STANDING_WITH_ITEM.get())) {
            tuffGolem.startSleepingWithItem();
        }
    }

    protected boolean shouldKeepRunning(class_3218 world, TuffGolemEntity tuffGolem, long time) {
        return tuffGolem.isInSleepingPose() && tuffGolem.method_18868().method_18904(FriendsAndFoesMemoryModuleTypes.TUFF_GOLEM_SLEEP_COOLDOWN.get()).isEmpty();
    }

    protected void finishRunning(class_3218 world, TuffGolemEntity tuffGolem, long time) {
        TuffGolemBrain.setSleepCooldown(tuffGolem);
        tuffGolem.stopMovement();
        if (tuffGolem.method_41328(TuffGolemEntityPose.SLEEPING.get())) {
            tuffGolem.startStanding();
        } else if (tuffGolem.method_41328(TuffGolemEntityPose.SLEEPING_WITH_ITEM.get())) {
            tuffGolem.startStandingWithItem();
        }
    }
}

